﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            HP 8657B: (1 yr) VER IEEE /N5531,PSA,LFCTR
DATE:                  2016-06-28 11:12:25
AUTHOR:                Fluke
REVISION:              $Revision: 2624 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       204
CONFIGURATION:         Agilent PSA (6.7 GHz,107,233)
CONFIGURATION:         Agilent EPM
CONFIGURATION:         Agilent N5532A (100.0 kHz - 4.2 GHz)
CONFIGURATION:         Low Frequency Counter
=============================================================================
#
#  Procedure Author:
#        DFM, DAC
#
#  Source:
#        Synthesized Signal Generator (Including Options 001, 002, and
#        003), Operation and Calibration Manual, Part No. 08657-90115,
#        March 1992, Section 4, Performance Tests
#
#  Additional Equipment Required:
#        Agilent N5532A-504 Sensor Module
#        Cable assy., 24", BNC(m)-(m), 50 Ω, 2 ea.
#        Tee BNC(f)-(m)-(f)
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  N5531        +Power = +13 dBm; Freq = 1900 MHz; SensorModule = N5532A
  1.003  IEEE         [@LFCTR]
  1.004  ENDIF

# Do not reset UUT after evalutions when posttest dialog is not displayed.
  1.005  VSET         ResetUUT = No

  1.006  ASK-   R   Q N              P                                     V

  1.007  IF           NOT(VERSIONCHECK("8.0"))
  1.008  END
  1.009  ENDIF

  1.010  CALL         Sub Display Copyright

# Initial hook-up information.
  1.011  HEAD         PRELIMINARY INSTRUCTIONS
  1.012  DISP         Ensure that the UUT REMOTE PORT is set for GPIB
  1.012  DISP         operation (the address is not important, as long
  1.012  DISP         as it is not (0) zero).

# Reset UUT and turn RF output off.  This must be done prior to connecting the
# sensor module to the UUT, otherwise the PSA may asset an SRQ and report the
# error: +143,"Final IF Overload"
  1.013  IEEE         [SDC]R2

# Establish UUT Reset command.  This command is sent whenever the post test
# dialog is displayed.
  1.014  RESET        R2

  1.015  DISP         Prior to beginning verification, a UUT warm-up time
  1.015  DISP         of 30 minutes (minimum) must have been allowed to
  1.015  DISP         elapse.

  1.016  CALL         Sub Connector Precautions (Type N)
  1.017  CALL         Sub Connector Precautions (SMA)
  1.018  CALL         Sub Connector Precautions (3.5 mm)
  1.019  CALL         Sub Select Failed Test Mode
  1.020  CALL         Sub Select Verification Method (No NTHROW)
  1.021  CALL         Sub UUT Connection GPIB

  1.022  HEAD         EQUIPMENT REQUIREMENTS
  1.023  OPBR         -z Do you want to review the list of additional
  1.023  OPBR         equipment and/or accessories required?

  1.024  IF           MEM1
  1.025  DISP         Additional equipment/accessories required:
  1.025  DISP
  1.025  DISP         - Cable assy., 24", BNC(m)-(m), 50 Ω, 2 ea.
  1.025  DISP         - Tee, BNC(f)-(m)-(f)
  1.026  ENDIF

  1.027  CALL         Sub Initialize /LFCTR
  1.028  CALL         Sub Reset /LFCTR

# Store UUT Model Number for subsequent use.
  1.029  MATH         @ModelNum = "8657B"

  1.030  HEAD         INSTALLED UUT OPTIONS
  1.031  RSLT         =
  1.032  RSLT         =INSTALLED OPTIONS:
  1.033  DISP         In the following steps, please indicate which options
  1.033  DISP         are currently installed in the UUT.
  1.033  DISP
  1.033  DISP         Installed options are found on the UUT identification
  1.033  DISP         tag (on the rear panel), opposite "OPT".

# Set flag for presence or lack of Option 001.
  1.034  OPBR         -z Does the UUT have Option 001 (High Stability
  1.034  OPBR         Timebase) installed?
  1.035  MATH         @Opt_001 = MEM1

# Set flag for presence or lack of Option 003.
  1.036  OPBR         -z Does the UUT have Option 003 (Pulse Modulation)
  1.036  OPBR         installed?
  1.037  MATH         @Opt_003 = MEM1

  1.038  IF           @Opt_001
  1.039  RSLT         = Option 001 (High Stability Timebase)
  1.040  DISP         Ensure the 'jumper' BNC (m)-(m) cable is connected
  1.040  DISP         from the TIME BASE HIGH STABILITY OUTPUT to the
  1.040  DISP         TIME BASE INPUT. Both are located on the UUT rear
  1.040  DISP         panel.

  1.041  DISP         Make the following connections:
  1.041  DISP
  1.041  DISP         [32]   House Std    to    [V @LFCTR_DevName]
  1.041  DISP         [32]  10 MHz OUT -------> [V @LFCTR_RefIn]
  1.042  ENDIF

  1.043  IF           @Opt_003
  1.044  RSLT         = Option 003 (Pulse Modulation)
  1.045  ENDIF

  1.046  IF           NOT(@Opt_001) && NOT(@Opt_003)
  1.047  RSLT         = None
  1.048  ENDIF

  1.049  HEAD         INITIAL CONNECTIONS
  1.050  DISP         Connect a BNC Tee to [V @LFCTR_DevName] [V @LFCTR_Ch1].
  1.050  DISP
  1.050  DISP         Connect one side of the tee to UUT TIME BASE OUTPUT.
  1.050  DISP
  1.050  DISP         Connect the other side of the tee to PSA EXT REF IN.
  1.050  DISP
  1.050  DISP         Both connections are located on the respective units'
  1.050  DISP         rear panels.

  1.051  PSA          Calibrate; All

  1.052  MATH         CM(1, "RF OUTPUT")
  1.053  MATH         CM(2, "MOD AM/FM 1V PEAK IN/OUT")

# Force automatic connection message for Audio input and N5532A Sensor Module.
  1.054  N5531        Connect; Input = Audio
  1.055  N5531        Connect; Input = RF; Freq = 3 MHz; SensorModule = N5532A

  1.056  CALL         Sub N5531S Sensor Use Information
  1.057  CALL         Sub N5531S Connection Precautions

  1.058  RSLT         =
  1.059  HEAD         {SPECTRAL PURITY TESTS}
  1.060  CALL         Sub HP 8657B/D (1 yr) Spurious Signals VER IEEE /PSA
  1.061  CALL         Sub HP 8657x (1 yr) Residual AM VER IEEE /N5531
  1.062  CALL         Sub HP 8657x (1 yr) Residual FM VER IEEE /N5531
  1.063  CALL         Sub HP 8657x (1 yr) Residual AM Test IEEE /N5531
  1.064  CALL         Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531
  1.065  CALL         Sub HP 8657B/D (1 yr) Phase Noise VER IEEE /PSA

  1.066  RSLT         =
  1.067  HEAD         {OUTPUT LEVEL ACCURACY AND FLATNESS TESTS}
  1.068  CALL         Sub HP 8657x (1 yr) Level Flatness VER IEEE /N5531
  1.069  CALL         Sub HP 8657B/D (1 yr) Level Accuracy VER IEEE /N5531

  1.070  RSLT         =
  1.071  HEAD         {MODULATION TESTS}
  1.072  CALL         Sub HP 8657x (1 yr) AM Accuracy VER IEEE /N5531
  1.073  CALL         Sub HP 8657x (1 yr) Incidental PM VER IEEE /N5531
  1.074  CALL         Sub HP 8657x (1 yr) AM Distortion VER IEEE /N5531
  1.075  CALL         Sub HP 8657x (1 yr) FM Accuracy VER IEEE /N5531
  1.076  CALL         Sub HP 8657x (1 yr) Incidental AM VER IEEE /N5531
  1.077  CALL         Sub HP 8657x (1 yr) FM Distortion VER IEEE /N5531
  1.078  CALL         Sub HP 8657x (1 yr) DC FM Freq Error VER IEEE /N5531
  1.079  CALL         Sub HP 8657x (1 yr) Mod Source VER IEEE /N5531

  1.080  IF           @Opt_003
  1.081  RSLT         =
  1.082  HEAD         MODULATION TESTS: {PULSE MODULATION}
  1.083  RSLT         = Not Tested!
  1.084  ENDIF

  1.085  RSLT         =
  1.086  HEAD         {OUTPUT LEAKAGE TEST}
  1.087  RSLT         = Not Tested!

  1.088  RSLT         =
  1.089  HEAD         {TIME-BASE FREQUENCY OFFSET TEST}
  1.090  CALL         Sub HP 8657x (1 yr) Timebase Offset VER IEEE /LFCTR

  1.091  END
